﻿#target photoshop-11
// (c) Copyright 2008.  Adobe Systems, Incorporated.  All rights reserved.
/*
@@@BUILDINFO@@@ photoshop_web_contact_sheet.jsx 1.0.0.2  9-Jan-2008
*/


/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe Photoshop CS4 - Web Photo Gallery</dc:title>
     <dc:description>This script enables an optional plug-in called Web Photo Gallery.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe Photoshop CS4 - Galerie Web Photo</dc:title>
     <dc:description>Ce script active un module externe facultatif appelé Galerie Web Photo.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe Photoshop CS4 - Web フォトギャラリー</dc:title>
     <dc:description>このスクリプトにより、「Web フォトギャラリー」というオプションのプラグインが有効になります。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe Photoshop CS4 - Web-Fotogalerie</dc:title>
     <dc:description>Mithilfe dieses Skripts wird das optionale Zusatzmodul &quot;Web-Fotogalerie&quot; aktiviert.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe Photoshop CS4 - Galleria di foto per Web</dc:title>
     <dc:description>Questo script abilita il plug-facoltativo Galleria di foto per Web.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe Photoshop CS4 - Galería de fotografías Web</dc:title>
     <dc:description>Esta secuencia de comandos activa el plugin opcional denominado Galería de fotografías Web.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe Photoshop CS4 - Webfotogalerie</dc:title>
     <dc:description>Met dit script schakelt u een optionele plug-in in die Webfotogalerie heet.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe Photoshop CS4 - Galeria de Fotos na Web</dc:title>
     <dc:description>Este script habilita um plug-in opcional chamado Galeria de Fotos na Web.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe Photoshop CS4 – Web-fotogalleri</dc:title>
     <dc:description>Dette skriptet aktiverer en ekstra plugin-modul som kalles Web-fotogalleri.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe Photoshop CS4 - Webfotogalleri</dc:title>
     <dc:description>Dette script aktiverer et valgfrit ekstramodul med navnet Webfotogalleri.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>Adobe Photoshop CS4 - Web-valokuvagalleria</dc:title>
     <dc:description>Tämä komentosarja ottaa käyttöön valinnaisen plug-in-moduulin nimeltä Web-valokuvagalleria.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe Photoshop CS4 - Webbfotogalleri</dc:title>
     <dc:description>Det här skriptet aktiverar en valfri plug-in som kallas Webbfotogalleri.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe Photoshop CS4 - 網路相片收藏館</dc:title>
     <dc:description>此指令碼能啟動一個名為「網路相片收藏館」的選擇性增效模組。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe Photoshop CS4 - Web 照片画廊</dc:title>
     <dc:description>该脚本启用名为“Web 照片画廊”的可选增效工具。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe Photoshop CS4 – 웹 포토 갤러리</dc:title>
     <dc:description>이 스크립트를 통해 웹 포토 갤러리라고 하는 선택적 플러그인을 사용할 수 있습니다.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ar_AE">
     <dc:title>Adobe Photoshop CS4 - Web Photo Gallery</dc:title>
     <dc:description>يمكن البرنامج النصي هذا إضافة اختيارية يطلق عليها Web Photo Gallery.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="cs_CZ">
     <dc:title>Adobe Photoshop CS4 – Fotogalerie pro web</dc:title>
     <dc:description>Tento skript umožňuje volitelný zásuvný modul Fotogalerie pro web.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="el_GR">
     <dc:title>Adobe Photoshop CS4 - Συλλογή εικόνων web</dc:title>
     <dc:description>Αυτή η δέσμη ενεργειών ενεργοποιεί την προαιρετική επέκταση Συλλογή φωτογραφιών web.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_MX">
     <dc:title>Adobe Photoshop CS4 - Galería de fotografías Web</dc:title>
     <dc:description>Esta secuencia de comandos activa el plugin opcional denominado Galería de fotografías Web.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_CA">
     <dc:title>Adobe Photoshop CS4 - Galerie Web Photo</dc:title>
     <dc:description>Ce script active un module externe facultatif appelé Galerie Web Photo.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_XM">
     <dc:title>Adobe Photoshop CS4 - Galerie Web Photo</dc:title>
     <dc:description>Ce script active un module externe facultatif appelé Galerie Web Photo.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="he_IL">
     <dc:title>Adobe Photoshop CS4 - Web Photo Gallery</dc:title>
     <dc:description>סקריפט זה מפעיל תוסף אופציונלי הנקרא Web Photo Gallery.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="hu_HU">
     <dc:title>Adobe Photoshop CS4 - Webes fotógaléria</dc:title>
     <dc:description>Ez a parancsfájl a Webes fotógaléria nevű választható bővítmény használatát engedélyezi.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pl_PL">
     <dc:title>Adobe Photoshop CS4 — Internetowa galeria zdjęć</dc:title>
     <dc:description>Ten skrypt umożliwia korzystanie z opcjonalnej wtyczki o nazwie Internetowa galeria zdjęć.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ro_RO">
     <dc:title>Adobe Photoshop CS4 - Galerie foto Web</dc:title>
     <dc:description>Acest script activează un plug-in opţional denumit Galerie foto Web.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ru_RU">
     <dc:title>Adobe Photoshop CS4 - Фотогалерея Web</dc:title>
     <dc:description>Этот сценарий включает дополнение "Фотогалерея Web".</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="tr_TR">
     <dc:title>Adobe Photoshop CS4 - Web Fotoğraf Galerisi</dc:title>
     <dc:description>Bu komut dosyası, Web Fotoğraf Galerisi adında isteğe bağlı bir eklentiyi etkinleştirir.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="uk_UA">
     <dc:title>Adobe Photoshop CS4 - Веб-фотогалерея</dc:title>
     <dc:description>Цей сценарій активує додатковий модуль &quot;Веб-фотогалерея&quot;.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/

try
{ // Overall try catch

//=================================================================
// Web Photo Gallery
// Sets up Photoshop's Web Photo Gallery automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Web Photo Gallery with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop.webPhotoGallery = function (files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
			
		if (!photoshop.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// Web Photo Gallery with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop.versionInfo.btTargetName;
			btMessage.body = "photoshop.webPhotoGallery (" + files.toSource () + ");";			
			btMessage.send ();
			}
		else
			{
			photoshop.runActionCommand ('4C1ABF41-DD82-11d2-B20F-0008C75B322C', files);
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Web Photo Gallery menu
// item is chosen.
//-----------------------------------------------------------------
photoshop.webPhotoGalleryFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
			
		if (!photoshop.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop.webPhotoGallery (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the Web Photo Gallery menu item into the
// Bridge menus.
//-----------------------------------------------------------------
var menuItemInfo = new Object;

if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion.indexOf (photoshop.versionInfo.bridgeTargetVersion) == 0))
	{	
	// Use temp function to keep vars out of global namespace.
	photoshop.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/WPG=Web Photo Gallery...");
		menuItemInfo.name = 'WebPhotoGallery';
		menuItemInfo.onSelect = photoshop.webPhotoGalleryFromBridge;
		
		photoshop.menuItemInfoArray.push (menuItemInfo);
		}
	photoshop.tempFunction ();
	delete photoshop.tempFunction;
	}


//-----------------------------------------------------------------
// The code below adds the optional plug-in to the
// Photoshop sub-menu
//-----------------------------------------------------------------

// Define a function that will sort the menu items for us.
function menuTextOrder (a, b)
	{
	// Pass 'a' into 'b' to get reverse sort order so that they can be
	// added at the top of the menu and still be in alphabetical order
	// (the WAS scripts install additional menu items that end up below
	// these).
	return b.text.toLocaleLowerCase ().localeCompare (a.text.toLocaleLowerCase ());
	}

// Sort the menu items again
photoshop.menuItemInfoArray.sort (menuTextOrder);

// After sorting, find its index and place in the correct place of the menu
for(var i=0; i < photoshop.menuItemInfoArray.length; i++){
	if(photoshop.menuItemInfoArray[i].name == menuItemInfo.name){
		var subMenu;
		if(i == photoshop.menuItemInfoArray.length - 1){
			subMenu = MenuElement.create('command', menuItemInfo.text, 'at the beginning of tools/ps', menuItemInfo.name);
		} else if (i == 0){
			subMenu = MenuElement.create('command', menuItemInfo.text, 'at the end of tools/ps', menuItemInfo.name);
		} else {
			subMenu = MenuElement.create('command', menuItemInfo.text, 'after ' + photoshop.menuItemInfoArray[i+1].name, menuItemInfo.name);
		}
		subMenu.onSelect = menuItemInfo.onSelect;
		delete subMenu;
		break;
	}
}

} // Overall try catch
catch (e)
{
	// Debugging
	//alert ("photoshop_web_contact_sheet.jsx - " + e + ": " + e.line);
}
